<script type="text/javascript">

$(document).ready( function () {
    $('#dataTable').DataTable();
} );

$(document).ready(function () {
    $('#example').DataTable();
});
</script>


<div class="card shadow mb-4">
	<div class="card-header py-3">
		<h6 class="m-0 font-weight-bold text-primary">Rental</h6>
	</div>
	<div class="card-body">
		<div class="table-responsive">
			<!--<table class="table table-bordered" id="dataTable" widtd="70%" cellspacing="0" style="font-size: 12px">-->
			<table class="table table-bordered table-hover table-sm" id="dataTable" widtd="70%" cellspacing="0" style="font-size: 12px">
					<tr>
						<td valign="top" align="center" rowspan="4"><b>BIL</b></td>
						<td valign="middle" align="center" rowspan="4"><b>NAMA</b></td>
						<td valign="middle" align="center" rowspan="4"><b>NO UNIT</b></td>
						<td rowspan="4"><b>INVOICE NO</b></td>
						<td rowspan="4"><b>MONTH/YEAR</b></td>
						<td align = "center" ><b>BILL AMOUNT (RM)</b></td>
						<td align = "center" ><b>PAID AMOUNT (RM)</b></td>
						<td align = "center" ><b>OUTSTANDING AMOUNT (RM)</b></td>
						<td align = "center" ><b>PAYMENT STATUS</b></td>
					</tr>
					
				<?PHP 
				$no = 1;
				$outstanding = 0.00;
				$sumBillAmount = 0.00;
				$sumAmountPaid = 0.00;
				$sumOutstanding = 0.00;
				$outstandingBill = 0.00;
				$sumAdvance = 0.00;
				$sumALL = 0.00;
				while($resultRental = mysqli_fetch_array($runRental)){
					$tenant_name = $resultRental["tenant_name"];
					$unit_no = $resultRental["unit_no"];
					$bill_no = $resultRental["bill_no"];
					$tenant_id = $resultRental["tenant_id"];
					$payment_id = $resultRental["payment_id"];
					$bill_amount = $resultRental["bill_amount"];
					$amount_paid = $resultRental["amount_paid"];
					$bill_type_id = $resultRental["bill_type_id"];
					$payment_status = $resultRental["payment_status"];
					
					//set payment type = Outstanding / Normal / Advance
					$payment_type = "";
					$issue_date = date("m/Y", strtotime($resultRental["issue_date"]));
					$created_at = date("d/m/Y", strtotime($resultRental["created_at"]));
					
					//if bill_type_id not in (1,2), payment type = Outstanding (what ever reason), 1 = rental, 2 = water
					if($bill_type_id != 1 && $bill_type_id != 2)
						$payment_type = "Outstanding";
					else{
						//1. Outstanding
						if($created_at > $issue_date){
							 $payment_type = "Outstanding";
						}
						//2. Normal
						else if($created_at == $issue_date){
							 $payment_type = "Normal";
						}
						//3. Advance
						else if($created_at < $issue_date){
							 $payment_type = "Advance";
						}
					}
					$outstanding = $bill_amount - $amount_paid;
					
				?>
				 <tbody>
				<tr>
					<td><?php echo $no; ?></td>
					<td><a href="viewTenantDashboard.php?tenant_id=<?php echo $tenant_id?>"><?php echo strtoupper($tenant_name); ?></a></td>
					<td><?php echo $unit_no; ?></td>
					<td><a href="bill/print.php?report_type=<?php echo $report_type?>&tenant_id=<?php echo $tenant_id?>&id=<?php echo $bill_id?>"><?php echo $bill_no; ?></a></td>
					<td><?php echo date("m/Y",strtotime($resultRental["issue_date"])); ?></td>
					<td><?php echo number_format($bill_amount,2,".",","); ?></td>
					<td><?php echo number_format($amount_paid,2,".",","); ?></td>
					
					<td><?php echo number_format($outstanding,2,".",","); ?></td>
					<td><?php echo strtoupper($payment_status); ?></td>
					
					<?php 
						$sumBillAmount += $bill_amount;
						$sumAmountPaid += $amount_paid;
						$sumOutstanding += $outstanding;
					?>
					
				</tr>
				
				<?php 
				
				$no++;
				} 
				?>
				<tfoot>
				<tr>
					<td colspan="5"><b>TOTAL (RM)</b></td>
					<td><b><?php echo number_format($sumBillAmount,2,".",",");?></b></td>
					<td><b><?php echo number_format($sumAmountPaid,2,".",",");?></b></td>
					<td><b><?php echo number_format($sumOutstanding,2,".",",");?></b></td>
					<td></td>
				</tr>
				<?PHP 
				$outstandingBill  = $sumBillAmount - $sumAmountPaid;
				?>
				<tr>
					<td colspan="5"><b>TOTAL OUTSTANDING(RM)</b></td>
					<td colspan="7" align="center"><b><?php echo number_format($outstandingBill,2,".",",");?></b></td>
				</tr>
				</tfoot>
				 </tbody>
			</table>
		</div>
	</div>
</div>